<?php

namespace App\Component;

use App\Entity\MinistryDepartment;
use App\Form\MinistryDepartmentType;
use DateTimeImmutable;
use Doctrine\ORM\EntityManagerInterface;
use Exception;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\Form\FormInterface;
use Symfony\UX\LiveComponent\Attribute\AsLiveComponent;
use Symfony\UX\LiveComponent\Attribute\LiveAction;
use Symfony\UX\LiveComponent\Attribute\LiveProp;
use Symfony\UX\LiveComponent\ComponentToolsTrait;
use Symfony\UX\LiveComponent\ComponentWithFormTrait;
use Symfony\UX\LiveComponent\DefaultActionTrait;

#[AsLiveComponent('MinistryDepartmentForm')]
class MinistryDepartmentForm extends AbstractController
{
    use ComponentWithFormTrait;
    use DefaultActionTrait;
    use ComponentToolsTrait;

    #[LiveProp(writable: true)]
    public MinistryDepartment $department;

    #[LiveProp(writable: true)]
    public bool $success = false;
    public string $successMessage = 'Ministry created successfully go to <a href="/admin/ministry-department">ministry list</a>';
    public ?string $error = null;

    #[LiveAction]
    public function save(EntityManagerInterface $entityManager)
    {
        $this->submitForm();

        /** @var MinistryDepartment $ministryDepartmentModel */
        $ministryDepartmentModel = $this->getForm()->getData();
        $ministryDepartmentModel->setCreatedAt(new DateTimeImmutable());
        $ministryDepartmentModel->setCreatedBy($this->getUser()->getUserIdentifier());


        //dd($ministryDepartmentModel->getMinistry());
        try {

            $entityManager->persist($ministryDepartmentModel);
            $entityManager->flush();
        } catch (Exception $ex) {
            $this->error = $ex->getMessage();
            $this->success = false;
            return;
        }


        $this->success = true;
    }

    protected function instantiateForm(): FormInterface
    {
        return $this->createForm(MinistryDepartmentType::class, $this->department);
    }

    private function getDataModelValue(): ?string
    {
        return 'norender|*';
    }
}