<?php

namespace App\Component;

use App\Entity\Ministry;
use App\Entity\NewsLetterSubscriptions;
use App\Form\MinistryType;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\Form\FormInterface;
use Symfony\UX\LiveComponent\Attribute\AsLiveComponent;
use Symfony\UX\LiveComponent\Attribute\LiveAction;
use Symfony\UX\LiveComponent\Attribute\LiveProp;
use Symfony\UX\LiveComponent\ComponentToolsTrait;
use Symfony\UX\LiveComponent\ComponentWithFormTrait;
use Symfony\UX\LiveComponent\DefaultActionTrait;

#[AsLiveComponent('MinistryForm')]
class MinistryForm extends AbstractController
{
    use ComponentWithFormTrait;
    use DefaultActionTrait;
    use ComponentToolsTrait;

    #[LiveProp(writable: true)]
    public ?Ministry $ministryEn = null;

    #[LiveProp(writable: true)]
    public bool $success= false;
    public string $successMessage = 'Ministry created successfully go to <a href="/admin/ministry">ministry list</a></a>';
    public ?string $error = null;

    protected function instantiateForm(): FormInterface
    {
        return $this->createForm(MinistryType::class, $this->ministryEn);
    }
    private function getDataModelValue(): ?string
    {
        return 'norender|*';
    }
    #[LiveAction]
    public function save(EntityManagerInterface $entityManager)
    {
        $this->submitForm();

        /** @var Ministry $ministryModel */
        $ministryModel = $this->getForm()->getData();
        $ministryModel->setCreatedAt(new \DateTimeImmutable());
        $ministryModel->setUpdatedAt(new \DateTimeImmutable());
        $ministryModel->setCreatedBy($this->getUser()->getUserIdentifier());

        try {
            $entityManager->persist($ministryModel);
            $entityManager->flush();
        }catch(\Exception $ex){
            $this->error = $ex->getMessage();
            $this->success = false;
            return;
        }

        $this->success = true;
    }
}