<?php

namespace App\Component;

use App\Entity\User;
use App\Form\UserType;
use App\Repository\UserRepository;
use App\Shared\AppConst;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\Form\FormInterface;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\PasswordHasher\Hasher\UserPasswordHasherInterface;
use Symfony\UX\LiveComponent\Attribute\AsLiveComponent;
use Symfony\UX\LiveComponent\Attribute\LiveAction;
use Symfony\UX\LiveComponent\Attribute\LiveArg;
use Symfony\UX\LiveComponent\Attribute\LiveListener;
use Symfony\UX\LiveComponent\Attribute\LiveProp;
use Symfony\UX\LiveComponent\ComponentToolsTrait;
use Symfony\UX\LiveComponent\ComponentWithFormTrait;
use Symfony\UX\LiveComponent\DefaultActionTrait;
use Symfony\UX\LiveComponent\LiveResponder;

#[AsLiveComponent('UsersForm')]
class UsersForm extends AbstractController
{
    use ComponentWithFormTrait;
    use DefaultActionTrait;
    use ComponentToolsTrait;

    #[LiveProp(writable: true)]
    public ?User $employee = null;

    private UserRepository $usersRepository;

    public function __construct(UserRepository $usersRepository)
    {
        $this->usersRepository = $usersRepository;
    }
    protected function instantiateForm(): FormInterface
    {
        return $this->createForm(UserType::class, $this->employee);
    }

    #[LiveAction]
    public function save(
        EntityManagerInterface      $entityManager,
        UserPasswordHasherInterface $userPasswordHasher,
        Request                     $request
    ): void
    {

        $this->submitForm();
        //$this->form->handleRequest($request);

        /** @var User $user */
        $user = $this->getForm()->getData();
        $user->setPassword(
            $userPasswordHasher->hashPassword(
                $user,
                $user->getPassword()
            )
        );
        $entityManager->persist($user);
        $entityManager->flush();
        $this->resetForm();
        $this->dispatchBrowserEvent('modal:close');
        $this->emit('modalClosed');
        $this->emit('userAdded', [], 'UsersList');


    }
    #[LiveListener('edit:user')]
    public function prepareFormForEdit(#[LiveArg] int $id)
    {
        $user = $this->usersRepository->find($id);

        // If the user is not found, you may want to handle this case
        if (!$user) {
            // Handle not found
        }
        $this->getForm()->setData($user);
        $this->getForm()->initialize();
        $this->employee = $user;


    }


}