<?php

namespace App\Controller;

use App\Entity\NewsLetterSubscriptions;
use App\Entity\Post;
use App\Form\NewsLetterSubscriptionsType;
use App\Repository\CountyRepository;
use App\Repository\PostRepository;
use App\Shared\AppConst;

use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;

class HomeController extends AbstractController
{
    #[Route('/', name: 'app_home')]
    public function index(CountyRepository $countyRepository,
                          PostRepository $postRepository,Request $request): Response
    {

        $newsLetterSubscription = new NewsLetterSubscriptions();
        $form = $this->createForm(NewsLetterSubscriptionsType::class, $newsLetterSubscription);
        $form->handleRequest($request);
        return $this->render('home/home.html.twig',[
             AppConst::APP_LAYOUT => AppConst::USER_LAYOUT,
                'title' => 'HOME |'. AppConst::APP_NAME,
                'posts' => $postRepository->findLatestPosts(),
                'counties' => $countyRepository->findAll(),
                'form' =>$form,
                'subscription' => $newsLetterSubscription
            ]
        );
    }
}
