<?php

namespace App\Controller;

use App\Entity\MinistryDepartment;
use App\Form\MinistryDepartmentType;
use App\Repository\MinistryDepartmentRepository;
use App\Shared\AppConst;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Attribute\Route;

#[Route(AppConst::APP_ADMIN_ROUTE_PREFIX.'/ministry-department')]
class MinistryDepartmentController extends AbstractController
{
    #[Route('/', name: 'app_ministry_department_index', methods: ['GET'])]
    public function index(MinistryDepartmentRepository $ministryDepartmentRepository): Response
    {
        return $this->render('ministry_department/index.html.twig', [
            'ministry_departments' => $ministryDepartmentRepository->findAll(),
            AppConst::APP_LAYOUT =>AppConst::ADMIN_LAYOUT,
            AppConst::ADMIN_LAYOUT_TITLE => 'Stats Post',
            'toolbar' =>['title' =>'Ministries','current' => 'Ministries']
        ]);
    }

    #[Route('/new', name: 'app_ministry_department_new', methods: ['GET', 'POST'])]
    public function new(Request $request, EntityManagerInterface $entityManager): Response
    {
        $ministryDepartment = new MinistryDepartment();
        $form = $this->createForm(MinistryDepartmentType::class, $ministryDepartment);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $entityManager->persist($ministryDepartment);
            $entityManager->flush();

            return $this->redirectToRoute('app_ministry_department_index', [], Response::HTTP_SEE_OTHER);
        }

        return $this->render('ministry_department/new.html.twig', [
            'ministry_department' => $ministryDepartment,
            'form' => $form,
            AppConst::APP_LAYOUT =>AppConst::ADMIN_LAYOUT,
            AppConst::ADMIN_LAYOUT_TITLE => 'Stats Post',
            'toolbar' =>['title' =>'Ministry Departments','current' => 'Add new department']
        ]);
    }

    #[Route('/{id}', name: 'app_ministry_department_show', methods: ['GET'])]
    public function show(MinistryDepartment $ministryDepartment): Response
    {
        return $this->render('ministry_department/show.html.twig', [
            'ministry_department' => $ministryDepartment,
        ]);
    }

    #[Route('/{id}/edit', name: 'app_ministry_department_edit', methods: ['GET', 'POST'])]
    public function edit(Request $request, MinistryDepartment $ministryDepartment, EntityManagerInterface $entityManager): Response
    {
        $form = $this->createForm(MinistryDepartmentType::class, $ministryDepartment);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $entityManager->flush();

            return $this->redirectToRoute('app_ministry_department_index', [], Response::HTTP_SEE_OTHER);
        }

        return $this->render('ministry_department/edit.html.twig', [
            'ministry_department' => $ministryDepartment,
            'form' => $form,
            AppConst::APP_LAYOUT =>AppConst::ADMIN_LAYOUT,
            AppConst::ADMIN_LAYOUT_TITLE => 'Stats Post',
            'toolbar' =>['title' =>'Ministry Departments','current' => 'Edit department']
        ]);
    }

    #[Route('/{id}', name: 'app_ministry_department_delete', methods: ['POST'])]
    public function delete(Request $request, MinistryDepartment $ministryDepartment, EntityManagerInterface $entityManager): Response
    {
        if ($this->isCsrfTokenValid('delete'.$ministryDepartment->getId(), $request->getPayload()->get('_token'))) {
            $entityManager->remove($ministryDepartment);
            $entityManager->flush();
        }

        return $this->redirectToRoute('app_ministry_department_index', [], Response::HTTP_SEE_OTHER);
    }
}
