<?php

namespace App\Controller;

use App\Entity\NewsLetterSubscriptions;
use App\Form\NewsLetterSubscriptionsType;
use App\Repository\NewsLetterSubscriptionsRepository;
use App\Shared\AppConst;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Attribute\Route;

#[Route(AppConst::APP_ADMIN_ROUTE_PREFIX.'/news-letter/subscriptions')]
class NewsLetterSubscriptionsController extends AbstractController
{
    #[Route('/', name: 'app_news_letter_subscriptions_index', methods: ['GET'])]
    public function index(NewsLetterSubscriptionsRepository $newsLetterSubscriptionsRepository): Response
    {
        return $this->render('news_letter_subscriptions/index.html.twig', [
            'news_letter_subscriptions' => $newsLetterSubscriptionsRepository->findAll(),
            AppConst::APP_LAYOUT =>AppConst::ADMIN_LAYOUT,
            AppConst::ADMIN_LAYOUT_TITLE => 'Stats Post',
            'toolbar' =>['title' =>'News-letter','current' => 'News letter subscription']
        ]);
    }


/*
    #[Route('/{id}/edit', name: 'app_news_letter_subscriptions_edit', methods: ['GET', 'POST'])]
    public function edit(Request $request, NewsLetterSubscriptions $newsLetterSubscription, EntityManagerInterface $entityManager): Response
    {
        $form = $this->createForm(NewsLetterSubscriptionsType::class, $newsLetterSubscription);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $entityManager->flush();

            return $this->redirectToRoute('app_news_letter_subscriptions_index', [], Response::HTTP_SEE_OTHER);
        }

        return $this->render('news_letter_subscriptions/edit.html.twig', [
            'news_letter_subscription' => $newsLetterSubscription,
            'form' => $form,
        ]);
    }*/

}
