<?php

namespace App\Entity;

use ApiPlatform\Metadata\ApiResource;
use App\Repository\DatasetRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

#[ApiResource]
#[ORM\Entity(repositoryClass: DatasetRepository::class)]
class Dataset
{
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column]
    private ?int $id = null;

    /**
     * @var Collection<int, county>
     */
    #[ORM\ManyToMany(targetEntity: county::class)]
    private Collection $counties;

    public function __construct()
    {
        $this->counties = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    /**
     * @return Collection<int, county>
     */
    public function getCounties(): Collection
    {
        return $this->counties;
    }

    public function addCounty(county $county): static
    {
        if (!$this->counties->contains($county)) {
            $this->counties->add($county);
        }

        return $this;
    }

    public function removeCounty(county $county): static
    {
        $this->counties->removeElement($county);

        return $this;
    }
}
