<?php

namespace App\Entity;

use ApiPlatform\Metadata\ApiResource;

use App\Repository\EmployeeDepartmentRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Entity(repositoryClass: EmployeeDepartmentRepository::class)]
#[ApiResource]
class EmployeeDepartment extends BaseEntity
{

    #[ORM\Column(length: 72)]
    private ?string $EmployeeDepartmentID = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $EmployeeDepartmentDescription = null;

    /**
     * @var Collection<int, User>
     */
    #[ORM\OneToMany(targetEntity: User::class, mappedBy: 'Department')]
    private Collection $employees;

    public function __construct()
    {
        $this->employees = new ArrayCollection();
    }


    public function getEmployeeDepartmentID(): ?string
    {
        return $this->EmployeeDepartmentID;
    }

    public function setEmployeeDepartmentID(string $EmployeeDepartmentID): static
    {
        $this->EmployeeDepartmentID = $EmployeeDepartmentID;

        return $this;
    }

    public function getEmployeeDepartmentDescription(): ?string
    {
        return $this->EmployeeDepartmentDescription;
    }

    public function setEmployeeDepartmentDescription(?string $EmployeeDepartmentDescription): static
    {
        $this->EmployeeDepartmentDescription = $EmployeeDepartmentDescription;

        return $this;
    }

    /**
     * @return Collection<int, User>
     */
    public function getEmployees(): Collection
    {
        return $this->employees;
    }

    public function addEmployee(User $employee): static
    {
        if (!$this->employees->contains($employee)) {
            $this->employees->add($employee);
            $employee->setDepartment($this);
        }

        return $this;
    }

    public function removeEmployee(User $employee): static
    {
        if ($this->employees->removeElement($employee)) {
            // set the owning side to null (unless already changed)
            if ($employee->getDepartment() === $this) {
                $employee->setDepartment(null);
            }
        }

        return $this;
    }
}
