<?php

namespace App\Entity;

use App\Repository\MinistryDepartmentRepository;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Entity(repositoryClass: MinistryDepartmentRepository::class)]
class MinistryDepartment extends BaseEntity
{
    #[ORM\Column(length: 255)]
    private ?string $DepartmentID = null;

    #[ORM\ManyToOne(inversedBy: 'departments')]
    private ?Ministry $ministry = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $PrincipalSecritary = null;


    public function getDepartmentID(): ?string
    {
        return $this->DepartmentID;
    }

    public function setDepartmentID(string $DepartmentID): static
    {
        $this->DepartmentID = $DepartmentID;

        return $this;
    }

    public function getMinistry(): ?Ministry
    {
        return $this->ministry;
    }

    public function setMinistry(?Ministry $ministry): static
    {
        $this->ministry = $ministry;

        return $this;
    }

    public function getPrincipalSecritary(): ?string
    {
        return $this->PrincipalSecritary;
    }

    public function setPrincipalSecritary(?string $PrincipalSecritary): static
    {
        $this->PrincipalSecritary = $PrincipalSecritary;

        return $this;
    }
}
