<?php

namespace App\Form;

use App\Entity\Ministry;
use App\Entity\MinistryDepartment;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class MinistryDepartmentType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('DepartmentID',null,[
                'label' => 'Department Name',
                'attr'=>[
                    'class'=>'form-control form-control-solid'
                ]
            ])
            ->add('PrincipalSecritary',null,[
                'label' => 'Principal Secretary:',
                'attr'=>[
                    'class'=>'form-control form-control-solid'
                ]
            ])

            ->add('ministry',EntityType::class,[
                'placeholder'=>'Select Ministry',
                'class'=>Ministry::class,
                'choice_label' => 'MinistryID',
                'choice_value'=>'Id',
                'attr'=>[
                    'class'=>'form-select',
                    'data-control'=>'select',
                    'data-placeholder'=>'select ministry'
                ],
                'expanded'=>false,
                'multiple'=>false
            ])
        ;
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => MinistryDepartment::class,
        ]);
    }
}
