<?php

namespace App\Form;

use App\Entity\Ministry;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class MinistryType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('MinistryID',null, [
                'label' => 'Ministry Name',
                'attr'=>[
                    'class'=>'form-control form-control-solid'
                ]
            ])
            ->add('PrimeCabinetSecretary',null, [
                'label' => 'Prime Cabinet Secretary',
                'attr'=>[
                    'class'=>'form-control form-control-solid'
                ]
            ])
        ;
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => Ministry::class,
        ]);
    }
}
