<?php

namespace App\Form;

use App\Entity\Post;
use App\Entity\PostData;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\FileType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\UX\Dropzone\Form\DropzoneType;

class PostDataType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('FileType', ChoiceType::class, [
                'choices' => [
                    'xlsx' => 'xlsx',
                    'csv' => 'csv',
                    'txt' => 'txt',
                    'pdf' => 'pdf',
                    'doc' => 'doc',
                    'docx' => 'docx',
                    'rtf' => 'rtf',
                    'ods' => 'ods',
                    'odt' => 'odt',
                    'html' => 'html',
                    'json' => 'json',
                    'xml' => 'xml',
                    'xsl' => 'xsl',
                    'xhtml' => 'xhtml',
                    'xps' => 'xps',
                    'odp' => 'odp',
                ]
            ])
            ->add('file',  DropzoneType::class, [
                'attr' => [
                    'placeholder' => 'Drag and drop a file or click to browse',
                ]
            ])
        ;
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => PostData::class,
            'attr' => [
                'data-model' => 'norender|*',
                'enctype' => 'multipart/form-data',
        ]]);
    }
}
