<?php

namespace App\Repository;

use App\Entity\County;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\Persistence\ManagerRegistry;

/**
 * @extends ServiceEntityRepository<County>
 *
 * @method County|null find($id, $lockMode = null, $lockVersion = null)
 * @method County|null findOneBy(array $criteria, array $orderBy = null)
 * @method County[]    findAll()
 * @method County[]    findBy(array $criteria, array $orderBy = null, $limit = null, $offset = null)
 */
class CountyRepository extends ServiceEntityRepository
{
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, County::class);
    }


    public  function getCounties(?string $searchQuery)
    {
//        if ($searchQuery === null || $searchQuery === '') {
//            return $this->findAll();
//        }

        $qb = $this->createQueryBuilder('county');
        $qb
            ->andWhere(
                $qb->expr()->orX(
                    $qb->expr()->like('county.Code', ':searchQuery'),
                    $qb->expr()->like('county.capital', ':searchQuery'),
                    $qb->expr()->like('county.Name', ':searchQuery'),
                )
            )
            ->setParameter('searchQuery', '%' . $searchQuery . '%');

        return $qb->getQuery()->getResult();
    }
}
