<?php

// src/Twig/AppExtension.php

namespace App\Twig;

use App\Shared\AppConst;
use Twig\Extension\AbstractExtension;
use Twig\TwigFunction;

class AppExtension extends AbstractExtension
{
    public function getFunctions(): array
    {
        return [
            new TwigFunction('app_constant', [$this, 'getAppConstant']),
        ];
    }

    public function getAppConstant(string $constantName)
    {
        return constant('App\Shared\AppConst::' . $constantName);
    }
}
