<?php

namespace App\Twig\Components;

use AllowDynamicProperties;
use App\Entity\County;
use App\Entity\PostData;
use App\Form\PostType;
use App\Service\DataProcessor;
use DateTimeImmutable;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\Form\FormInterface;
use Symfony\Component\HttpFoundation\File\UploadedFile;
use Symfony\Component\HttpFoundation\RequestStack;
use Symfony\UX\Chartjs\Builder\ChartBuilderInterface;
use Symfony\UX\Chartjs\Model\Chart;
use Symfony\UX\LiveComponent\Attribute\AsLiveComponent;
use Symfony\UX\LiveComponent\Attribute\LiveAction;
use Symfony\UX\LiveComponent\Attribute\LiveProp;
use Symfony\UX\LiveComponent\ComponentToolsTrait;
use Symfony\UX\LiveComponent\ComponentWithFormTrait;
use Symfony\UX\LiveComponent\DefaultActionTrait;
use Symfony\UX\LiveComponent\LiveCollectionTrait;

#[AllowDynamicProperties] #[AsLiveComponent]
final class Post extends AbstractController
{
    use DefaultActionTrait;
    use ComponentToolsTrait;
    use ComponentWithFormTrait;
    use LiveCollectionTrait;

    /**
     * @var \App\Entity\Post|null
     */
    #[LiveProp(writable: true)]
    public \App\Entity\Post $postModel;
    #[LiveProp(writable: true, url: true)]
    public ?string $query = null;
    public array $chartOptions = [];
    public $data = [];
    #[LiveProp(writable: true, url: true)]
    public $fileType = [];
    #[LiveProp(writable: true, url: true)]
    public $file = [];
    #[LiveProp]
    public array $checkList = [];
    #[LiveProp(writable: true)]
    public bool $workflowComplete = false;
    #[LiveProp(writable: true)]
    public bool $mainComplete = false;
    #[LiveProp(writable: true)]
    public bool $countiesComplete = false;
    #[LiveProp(writable: true)]
    public bool $dataComplete = false;
    #[LiveProp(writable: true)]
    public bool $settingsComplete = false;
    private EntityManagerInterface $entityManager;

    public function __construct(
        EntityManagerInterface                 $entityManager,
        private readonly ChartBuilderInterface $chartBuilder,
        DataProcessor                          $dataProcessor,
        RequestStack                           $requestStack

    )
    {
        $this->entityManager = $entityManager;
        $this->dataProcessor = $dataProcessor;
        $this->requestStack = $requestStack;

    }

    #[LiveAction]
    public function isCountiesComplete(): bool
    {
        return $this->countiesComplete;
    }

    #[LiveAction]
    public function isMainComplete(): bool
    {
        return $this->mainComplete;
    }

    #[LiveAction]
    public function isSettingsComplete(): bool
    {
        return $this->settingsComplete;
    }

    #[LiveAction]
    public function isDataComplete(): bool
    {
        return $this->dataComplete;
    }

    #[LiveAction]
    public function beginFileProcessing()
    {

        $this->submitForm();

        /** @var \App\Entity\Post $post */
        $post = $this->form->getData();

        dd($post);

        $post->setCreatedAt(new DateTimeImmutable());

        $this->entityManager->persist($post);
        $this->entityManager->flush();

        $this->addFlash('success', 'Post saved');
        /*$this->submitForm();


        dd($this->form->getData());*/
        /** @var PostData $postData */
        $postData = $this->form->get('data')->getData()[0];

        /** @var UploadedFile $file */
        /*$file = $this->form->get('file')->getData();
        $fileType = $this->form->get('FileType')->getData();

        if ($file && in_array($fileType, ['csv', 'xlsx'])) {
            $filePath = $file->getPathname();
            try {
                $this->dataProcessor->processFile($filePath);
                $this->chartOptions = $this->dataProcessor->getChartOptions();
            } catch (\Exception $e) {
                $this->chartOptions = ['error' => $e->getMessage()];
            }
        } else {
            $this->chartOptions = ['error' => 'Invalid file type or no file uploaded'];
        }*/
    }

    #[LiveAction]
    public function save()
    {
        $this->submitForm();

        /** @var \App\Entity\Post $post */
        $post = $this->form->getData();

        dd($this->postModel);
        $this->entityManager->persist($post);
        $this->entityManager->flush();

        $this->addFlash('success', 'Post saved');
    }

    /* private function getDataModelValue(): ?string
     {
         return 'norender|*';
     }*/

    #[LiveAction]
    public function getCounties()
    {

        //dd($this->query);
        return $this->entityManager->getRepository(County::class)->getCounties($this->query);
    }

    public function getChart()
    {
        $chart = $this->chartBuilder->createChart(Chart::TYPE_BAR);
        $chart->setData([
            'labels' => ['January', 'February', 'March', 'April', 'May', 'June', 'July'],
            'datasets' => [
                [
                    'label' => 'Cookies eaten 🍪',
                    'backgroundColor' => 'rgb(255, 99, 132, .4)',
                    'borderColor' => 'rgb(255, 99, 132)',
                    'data' => [2, 10, 5, 18, 20, 30, 45],
                    'tension' => 0.4,
                ],
                [
                    'label' => 'Km walked 🏃‍♀️',
                    'backgroundColor' => 'rgba(45, 220, 126, .4)',
                    'borderColor' => 'rgba(45, 220, 126)',
                    'data' => [10, 15, 4, 3, 25, 41, 25],
                    'tension' => 0.4,
                ],
            ],
        ]);

        $chart->setOptions([
            'maintainAspectRatio' => false,
        ]);

        $this->chart = $chart;


        return $this->chart;
    }

    #[LiveAction]
    public function getChecklist()
    {
        return $this->checkList;
    }

    public function isWorkflowComplete()
    {
        foreach ($this->checkList as $key => $value) {
            if (!$value) {
                return false;
            }
        }
        return true;
    }

    protected function instantiateForm(): FormInterface
    {
        return $this->createForm(PostType::class, $this->postModel);
    }

}
