<?php

namespace App\Twig\Extension;

use Twig\Extension\AbstractExtension;
use Twig\TwigFunction;

class MenuExtension extends AbstractExtension
{

    public function getFunctions(): array
    {
        return [
            new TwigFunction('is_active_menu', [$this, 'isActiveMenu']),
            new TwigFunction('parent_menu_active', [$this, 'activateParentMenuIfContainsActiveChild']),
        ];
    }
    public function isActiveMenu($activeMenu, $menuId): string
    {
       return $activeMenu === $menuId ?'menu-link active' : 'menu-link';

    }

    public function activateParentMenuIfContainsActiveChild(array $childrenIds, ?string $activeMenu)
    {
        if (in_array($activeMenu, $childrenIds, true)) {
            return ' hover show active ';
        }
        return '';
    }

}