import { BackendInterface } from '../Backend/Backend';
import ValueStore from './ValueStore';
import { ElementDriver } from './ElementDriver';
import { PluginInterface } from './plugins/PluginInterface';
import BackendResponse from '../Backend/BackendResponse';
export default class Component {
    readonly element: HTMLElement;
    readonly name: string;
    readonly listeners: Map<string, string[]>;
    private backend;
    readonly elementDriver: ElementDriver;
    id: string | null;
    fingerprint: string;
    readonly valueStore: ValueStore;
    private readonly unsyncedInputsTracker;
    private hooks;
    defaultDebounce: number;
    private backendRequest;
    private pendingActions;
    private pendingFiles;
    private isRequestPending;
    private requestDebounceTimeout;
    private nextRequestPromise;
    private nextRequestPromiseResolve;
    private externalMutationTracker;
    constructor(element: HTMLElement, name: string, props: any, listeners: Array<{
        event: string;
        action: string;
    }>, id: string | null, backend: BackendInterface, elementDriver: ElementDriver);
    addPlugin(plugin: PluginInterface): void;
    connect(): void;
    disconnect(): void;
    on(hookName: string, callback: (...args: any[]) => void): void;
    off(hookName: string, callback: (...args: any[]) => void): void;
    set(model: string, value: any, reRender?: boolean, debounce?: number | boolean): Promise<BackendResponse>;
    getData(model: string): any;
    action(name: string, args?: any, debounce?: number | boolean): Promise<BackendResponse>;
    files(key: string, input: HTMLInputElement): void;
    render(): Promise<BackendResponse>;
    getUnsyncedModels(): string[];
    emit(name: string, data: any, onlyMatchingComponentsNamed?: string | null): void;
    emitUp(name: string, data: any, onlyMatchingComponentsNamed?: string | null): void;
    emitSelf(name: string, data: any): void;
    private performEmit;
    private doEmit;
    private isTurboEnabled;
    private tryStartingRequest;
    private performRequest;
    private processRerender;
    private calculateDebounce;
    private clearRequestDebounceTimeout;
    private debouncedStartRequest;
    private renderError;
    private resetPromise;
    _updateFromParentProps(props: any): void;
}
export declare function proxifyComponent(component: Component): Component;
